import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp

# 定义微分方程的右侧函数 dy/dx = 1 / (1 + x^2)
def ode_function(x, y):
    return 1 / (1 + x**2)

# 初始条件
x0 = 0    # 初始 x 值
y0 = [0]  # y(x0) = arctan(0) = 0

# 解的范围
x_end = 5

# 使用 solve_ivp 来求解微分方程，使用 'RK45' 方法（这是默认的）
solution = solve_ivp(ode_function, [x0, x_end], y0, method='RK45', t_eval=np.linspace(x0, x_end, 500))

# 解析解
x_analytic = np.linspace(x0, x_end, 1000)
y_analytic = np.arctan(x_analytic)

# 绘制数值解与解析解
plt.figure(figsize=(10, 6))
plt.plot(solution.t, solution.y[0], 'bo-', label='数值解 (solve_ivp)', markersize=2)
plt.plot(x_analytic, y_analytic, 'r', label='解析解 $y=\\arctan(x)$')
plt.xlabel('x')
plt.ylabel('y')
plt.title('常微分方程 $\\frac{dy}{dx} = \\frac{1}{1+x^2}$ 的数值解与解析解')
plt.legend()
plt.grid(True)
plt.show()
