set more off
use mroz

reg wage educ exper age kidslt6 kidsge6
*reg为regress命令的缩写，wage（工资）是被解释变量，教育、经验、年龄小于6岁孩子个数、6到18岁孩子是解释变量。

reg wage educ exper age kidslt6 kidsge6, nocons
*该命令与第一个问题的实现方式基本一样，只是在最后加上了nocons选项，加了该选项后，Stata将进行无常数项的回归。

reg wage educ exper age kidslt6 kidsge6, level(99)
*level()用于指定读者希望的置信水平

reg wage educ exper age kidslt6 kidsge6, beta
*在回归命令后加上beta选项，Stata将为我们输出标准化的回归结果。

reg wage educ exper age kidslt6 kidsge6 if  inlf==1
*仅对inlf值取1的记录做回归

reg wage educ exper age kidslt6 kidsge6 if hours>=1000
*对工作时间大于1000小时的女性做回归

reg wage educ exper age kidslt6 kidsge6 if hours<1000
*对工作小时小于1000小时的女性做回归

reg wage educ exper age kidslt6 kidsge6
predict yhat    
* 该命令新建了一个名叫yhat的变量，用以存放拟合值
predict e, resid  
*该命令新建一个名叫e的变量，用以存放残差。

reg wage educ exper age kidslt6 kidsge6
test educ
*该命令用来检验教育的作用，即educ的系数是否为0。
test educ=0.5
*来检验教育的系数是否为0.5
test educ exper
*在STATA结果窗口输出我们关心的教育、经验是否联合显著
test educ=exper
*教育和经验的系数是否相等
test educ=(exper+age)/0.9
*这个命令用以检验教育的系数是否等于经验系数加年龄系数的0.9倍

reg wage age educ exper expersq kidslt6 kidsge6
*该命令用于工资不仅对经验做回归，还要对经验的平方做回归

reg lwage educ exper expersq age kidslt6 kidsge6
*对工资做对数变换后再做回归
