import numpy as np

def power_method(A, x0, tol=1e-6, max_iter=1000):
    x = x0
    m = max(x0)
    for i in range(max_iter):
        x_next = np.dot(A, x)
        x_next_norm = max(x_next, key=abs)
        x_next = x_next / x_next_norm
        if abs(x_next_norm - m) < tol:
            eigenvalue = x_next_norm
            eigenvector = x_next
            return eigenvalue, eigenvector, i + 1
        x = x_next
        m = x_next_norm
    raise ValueError("不收敛")


A = np.array([[4, -1, 1],
              [-1, 3, -2],
              [1, -2, 3]])
A_inv = np.linalg.inv(A)

initial_vectors = [
    np.array([1, 1, 1]),
    np.array([2.001, 1.999, 0])]

for i in range(1, 6):
    alpha = float(input("输入原点位移因子: ")) 

    B = A - alpha * np.eye(A.shape[0]) 
    B_inv = np.linalg.inv(B)

    for i, x0 in enumerate(initial_vectors, 1):
        try:
            eigenvalue_B, eigenvector_B, iterations_B = power_method(B_inv, x0)
            true_eigenvalue = 1 / eigenvalue_B + alpha
            print(f"加速方法 - 初始向量 {i}: {x0}")
            print(f"主特征值: {true_eigenvalue:.6f}")
            print(f"对应特征向量: {eigenvector_B}")
            print(f"迭代次数: {iterations_B}\n")
        except ValueError as e:
            print(f"加速方法 - 初始向量 {i}: {x0} {e}")