import numpy as np
from scipy.optimize import fsolve

def f(t, y):
    return -50 * y


def forth_RK(f, y0, t0, tn, h):
    length = int((tn + h - t0) / h)
    t_values = np.linspace(t0, tn, length)
    y_values = [y0]
    y_current = y0
    
    for i in range(1, len(t_values)):
        t_n1 = t_values[i]
        def equation(y_n1):
            return y_n1 - y_current - h * f(t_n1, y_n1)
        
        # 使用 fsolve 解非线性方程
        y_n1 = fsolve(equation, y_current)[0]
        
        # 更新 y_current 并添加到结果
        y_values.append(y_n1)
        y_current = y_n1
    
    return t_values, y_values

# 参数设置
y0 = 100          
t0 = 0          
tn = 0.1        
h_valuse = [0.1, 0.05, 0.01, 0.001]      

for h in h_valuse:
    t_values, y_values = forth_RK(f, y0, t0, tn, h)
    print(f"此时步长为：{h}")
    for t, y in zip(t_values, y_values):
        print(f"y({t:.3f}) = {y:.10f}")