import numpy as np
from scipy.optimize import fsolve

def f(t, y):
    return y**2

def g(t, y):
    return t / y

def improved_euler(f, y0, t0, tn, h):
    length = int((tn + h - t0) / h)
    t_values = np.linspace(t0, tn, length)
    y_values = [y0]
    y_current = y0
    
    for i in range(1, len(t_values)):
        t_n = t_values[i - 1]
        t_n1 = t_values[i]
        
        # 初步猜测 y_n1 使用 Euler 法
        y_midddle = y_current + h * f(t_n, y_current)
    
        # 加入猜测值使得结果更准确
        y_n1 = y_current + h * (f(t_n, y_current) + f(t_n1, y_midddle)) / 2
        
        # 更新 y_current 并添加到结果中
        y_values.append(y_n1)
        y_current = y_n1
    
    return t_values, y_values

# 参数设置
y0 = 1          
t0 = 0          
tn = 0.4        
h = 0.1         

# 计算数值解
t_values, y_values = improved_euler(f, y0, t0, tn, h)

# 输出
for t, y in zip(t_values, y_values):
    print(f"y({t:.1f}) = {y:.6f}")

y0 = 1          
t0 = 2.0   
tn = 2.6        
h = 0.1  
print("方程二")
# 计算数值解
t_values, y_values = improved_euler(g, y0, t0, tn, h)

# 输出
for t, y in zip(t_values, y_values):
    print(f"y({t:.1f}) = {y:.6f}")