import numpy as np
import math


def romberg_integration(f, a, b, eps=1e-6, max_iter=10000):
    
    T = np.zeros((max_iter, max_iter))  # 初始化存储T表格
    h = b - a  # 初始步长
    T[0, 0] = h * (f(a) + f(b)) / 2  # T_0^0

    for m in range(1, max_iter):
        # 计算 T_m^0
        h /= 2
        summation = sum(f(a + (2 * k - 1) * h) for k in range(1, 2**(m - 1) + 1))
        T[m, 0] = T[m-1, 0] / 2 + h * summation

        # 计算更高阶的 T_m^n
        for n in range(1, m + 1):
            T[m - n, n] = (4**n * T[m - n + 1, n - 1] - T[m - n, n - 1]) / (4**n - 1)

        # 判断精度
        if m > 3 and abs(T[m - 3, 3] - T[m - 4, 3]) < eps:
            return T[m - 3, 3], m

    raise ValueError("达到最大迭代次数，积分未收敛")



def f1(x):
    return math.exp(-x**2)


def f2(x):
    return math.sin(x) / x if x != 0 else 1



a, b = 0, 1

try:
    result1, iterations1= romberg_integration(f1, a, b)
    print(f"f1 的积分结果: {result1}, 迭代次数: {iterations1}")
except ValueError as e:
    print(e)

try:
    result2, iterations2 = romberg_integration(f2, a, b)
    print(f"f2 的积分结果: {result2}, 迭代次数: {iterations2}")
except ValueError as e:
    print(e)



