import numpy as np
import math

def f1(x):
    return math.exp(-x * x)

def f2(x):
    return math.sin(x) / x if x != 0 else 1

def initial(f, a, b):
    # 初始S_0
    h = (b - a) / 2
    return h * (f(a) + f(b))

def trapezoid_part(f, a, b, n):
    # 计算 S_n
    h = (b - a) / (2 * n) 
    odd_sum = 0 
    for k in range(1, n + 1):  
        odd_sum = odd_sum + f(a + (2 * k - 1) * h)
    return h * odd_sum


a, b = 0, 1
epsilon = 1e-6
s0 = initial(f1, a, b)
ss0 = initial(f2, a, b)
temp = s0


for i in range(0, 101):
    m = 2 ** i
    t = 0.5 * temp + trapezoid_part(f1, a, b, m)
    erro = abs(t - temp)
    if erro < epsilon:
        break
    temp = t
print(f"积分结果：{t}")
print(f"迭代次数：{i + 1}")

temp = ss0

for i in range(0, 101):
    m = 2 ** i
    t = 0.5 * temp + trapezoid_part(f2, a, b, m)
    erro = abs(t - temp)
    if erro < epsilon:
        break
    temp = t
print(f"积分结果：{t}")
print(f"迭代次数：{i + 1}")


