import numpy as np

def f1(x):
    return np.exp(-x * x)

def f2(x):
    return np.where(x != 0, np.sin(x) / x, 1)

def initial(f, a, b):
    # 初始S_0
    h = (b - a) / 2
    return h / 3 * (f(a) + 4 * f((a + b) / 2) + f(b))

def simpson_part(f, a, b, n):
    # 计算 S_n
    h = (b - a) / (2 * n)  
    x_values = np.linspace(a, b, 2 * n + 1)  
    odd_sum = np.sum(f(x_values[1::2]))  
    mod4_2_sum = np.sum(f(x_values[2::4]))  
    return h / 3 * (4 * odd_sum - 2 * mod4_2_sum)


a, b = 0, 1
epsilon = 1e-6
s0 = initial(f1, a, b)
ss0 = initial(f2, a, b)
temp = s0


for i in range(1, 101):
    m = 2 ** i
    t = 0.5 * temp + simpson_part(f1, a, b, m)
    erro = abs(t - temp)
    if erro < epsilon:
        break
    temp = t
print(f"积分结果：{temp}")
print(f"迭代次数：{i}")

temp = ss0

for i in range(1, 101):
    m = 2 ** i
    t = 0.5 * temp + simpson_part(f2, a, b, m)
    erro = abs(t - temp)
    if erro < epsilon:
        break
    temp = t
print(f"积分结果：{temp}")
print(f"迭代次数：{i}")