import numpy as np
import math

def f1(x):
    return math.exp(-x * x)

def f2(x):
    return math.sin(x) / x if x != 0 else 1  

def trapezoid(f, a, b):
    return (f(a) + f(b)) / 2 * (b - a)

def simpson(f, a, b):
    return (b - a) * (f(a) + 4 * f((a + b) / 2) + f(b)) / 6


a, b = 0, 1

# 计算 f1 的积分
m = trapezoid(f1, a, b)
mm = simpson(f1, a, b)
print("f1 梯形法积分结果:", m)
print("f1 辛普森积分结果:", mm)

# 计算 f2 的积分
mmm = trapezoid(f2, a, b)
mmmm = simpson(f2, a, b)
print("f2 梯形法积分结果:", mmm)
print("f2 辛普森积分结果:", mmmm)

