import numpy as np
import matplotlib.pyplot as plt
from scipy.interpolate import CubicSpline

def f(x):
    return 1 / (5 + x**2)

n_values = [1, 5, 10, 20]
x_plot = np.linspace(-5, 5, 500)
y_true = f(x_plot)

plt.figure(figsize=(10, 6))
plt.plot(x_plot, y_true, label="f(x) = 1 / (5 + x^2)", color='black')

for n in n_values:
    x_k = np.linspace(-5, 5, n + 1)
    y_k = f(x_k)
    cs = CubicSpline(x_k, y_k)
    y_interp = cs(x_plot)
    plt.plot(x_plot, y_interp, label=f'CubicSpline n={n}')

plt.legend()
plt.xlabel('x')
plt.ylabel('y')
plt.title('Cubic spline interpolation')
plt.grid(True)
plt.show()