import numpy as np
import math
import matplotlib.pyplot as plt

def f(x, n):
    return x**n

def vertical_matrix(n, x):
    m = len(x)
    matrix = np.zeros((n+1, n+1))
    for i in range(0, n + 1):
        for j in range(0, n + 1):
            for k in range(0, m):
                matrix[i, j] = matrix[i, j] + f(x[k], i) * f(x[k], j)
    print(matrix)
    return matrix

def y_matrix(n, x, y):
    A = []
    m = len(x)
    for i in range(0, n + 1):
        p = 0
        for k in range(0, m):
            p = p + y[k] * f(x[k], i)
        A.append(p)
    print(A)
    return np.array(A)


def squared_error(x_values, y_values, n, coeffs):
    m = len(x_values)
    error = 0
    for k in range(m):
        predicted_y = sum(coeffs[i] * f(x_values[k], i) for i in range(n+1))
        error += (y_values[k] - predicted_y) ** 2
    return error


n = 1
x_values = [1, 2, 3, 4, 5]
y_values = [4, 4.5, 6, 8, 8.5]

# Solve for coefficients
coeffs = np.linalg.solve(vertical_matrix(n, x_values), y_matrix(n, x_values, y_values))
print("解为：", coeffs)

# Compute squared error
error = squared_error(x_values, y_values, n, coeffs)
print("平方误差：", error)

# Plot original data points and fitted curve
x_plot = np.linspace(0, 7, 500)
predicted_y_values = [sum(coeffs[i] * f(x, i) for i in range(n + 1)) for x in x_plot]

plt.scatter(x_values, y_values, color='red', label='original points')
plt.plot(x_plot, predicted_y_values, color='blue', label='fitting curves')
plt.xlabel('X')
plt.ylabel('Y')
plt.title('fitting curves')
plt.legend()
plt.show()