import numpy as np
import math
import matplotlib.pyplot as plt
plt.rcParams['font.family'] = 'SimHei'

def f(x, n):
    return x**n

def vertical_matrix(n, x):
    m = len(x)
    matrix = np.zeros((n+1, n+1))
    for i in range(0, n + 1):
        for j in range(0, n + 1):
            for k in range(0, m):
                matrix[i, j] = matrix[i, j] + f(x[k], i) * f(x[k], j)
    print(matrix)
    return matrix

def y_matrix(n, x, y):
    A = []
    m = len(x)
    for i in range(0, n + 1):
        p = 0
        for k in range(0, m):
            p = p + y[k] * f(x[k], i)
        A.append(p)
    print(A)
    return np.array(A)


def squared_error(x_values, y_values, n, coeffs):
    m = len(x_values)
    error = 0
    for k in range(m):
        predicted_log_y = sum(coeffs[i] * f(x_values[k], i) for i in range(n+1))
        predicted_y = math.exp(predicted_log_y)
        error += (y_values[k] - predicted_y) ** 2
    return error


n = 1
real_x_values = [2, 3, 4, 7, 8, 10, 11, 14, 16, 18, 19]
real_y_values = [106.42, 108.2, 109.5, 110, 109.93, 110.49, 110.59, 110.6, 110.76, 111, 111.2]

x_values = [1 / x for x in real_x_values]
y_values = np.log(real_y_values)


# Solve for coefficients
coeffs = np.linalg.solve(vertical_matrix(n, x_values), y_matrix(n, x_values, y_values))
print("解为：", coeffs)

# Compute squared error
error = squared_error(x_values, real_y_values, n, coeffs)
print("平方误差：", error)

# Plot original data points and fitted curve
x_plot = np.linspace(1, 20, 500)
predicted_y_values = [math.exp(sum(coeffs[i] * f(1 / x, i) for i in range(n + 1))) for x in x_plot]

plt.scatter(real_x_values, real_y_values, color='red', label='原始数据点')
plt.plot(x_plot, predicted_y_values, color='blue', label='拟合曲线')
plt.xlabel('X 值')
plt.ylabel('Y 值')
plt.title('拟合曲线')
plt.legend()
plt.show()