import numpy as np
import matplotlib.pyplot as plt

def f(x):
    return 1 / (1 + x**2)

def divided_differences(x, y):
    n = len(y) - 1
    matrix = np.zeros((n+1, n+1))
    coef = np.copy(y)
    for i in range(0, n + 1):
        matrix[i, 0] = coef[i]
    for j in range(1, n + 1):
        for i in range(j, n + 1):
            matrix[i, j] = (matrix[i, j - 1] - matrix[i - 1, j - 1]) / (x[i] - x[i - j])
    for i in range(0, n + 1):
        coef[i] =  matrix[i, i]
    return coef

def newton_interpolation(x, coef, xp):
    n = len(coef)
    p = coef[0]
    for k in range(1, n):
        term = coef[k]
        for j in range(k):
            term *= (xp - x[j])
        p += term
    return p

def newton_interpolation_function(n, xp, x0, x2):
    x_k = np.linspace(x0, x2, n + 1)
    y_k = f(x_k)
    coef = divided_differences(x_k, y_k)
    return newton_interpolation(x_k, coef, xp)

n_values = [2]
m_values = [10, 20, 30, 40, 50]
x_plot = np.linspace(-5, 5, 500)
y_true = f(x_plot)

plt.figure(figsize=(10, 6))
plt.plot(x_plot, y_true, label="f(x) = 1 / (1 + x^2)", color='black')

for n in n_values:
    for m in m_values:
        y_interp = np.zeros_like(x_plot)  # 初始化与x_plot同大小的插值结果数组
        for i in range(1, m + 1):
            x0 = -5 + (10 * (i - 1)) / m
            x2 = -5 + (10 * i) / m  # 修正为分段的右端点
            mask = (x_plot >= x0) & (x_plot <= x2)  # 找到x_plot中属于当前区间的点
            if np.any(mask):  # 确保当前区间有点需要计算
                y_interp[mask] = newton_interpolation_function(n, x_plot[mask], x0, x2)

        plt.plot(x_plot, y_interp, label=f'Newton Interpolation, m={m}')

plt.legend()
plt.title("Comparison of Newton Interpolations for different partition")
plt.xlabel("x")
plt.ylabel("f(x)")
plt.grid(True)
plt.show()

