import sympy as sp
import math

x = sp.symbols('x')

x_values = [11 * math.pi / 180, 12 * math.pi / 180, 13 * math.pi / 180]  
y_values = [0.190809, 0.207912, 0.224951]  

def lagrange_basis(i, x_values):
    term = 1
    for j in range(len(x_values)):
        if i != j:
            term *= (x - x_values[j]) / (x_values[i] - x_values[j])
    return term

lagrange_polynomial = 0
for i in range(len(x_values)):
    lagrange_polynomial += y_values[i] * lagrange_basis(i, x_values)

lagrange_polynomial = sp.simplify(lagrange_polynomial)
print(lagrange_polynomial)

example_x = 11.5 * math.pi / 180
example_y = lagrange_polynomial.subs(x, example_x)
print(f"value at x = {example_x}:")
print(example_y)
nn = math.sin((11.5 * math.pi / 180))
erro = abs((nn - example_y) / nn)
print("erro term: ", erro)