﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Xml.Linq;

namespace 发电厂
{
    public class ConnectionManager
    {
        private List<(Node, Node)> Connections;
        private List<Element> elements;
        private UpdateStatus updateStatus;
        public ConnectionManager(List<Element> elements, List<(Node, Node)> Connections)
        {
            this.elements = elements;
            this.Connections = Connections;
            updateStatus = new UpdateStatus(elements, Connections);
        }

        private Node selectedNode1 = null;
        private Node selectedNode2 = null;
        // 连接元素的节点
        public void ConnectElements(PointF clickPoint)
        {
            Node clickedNode = null;
            foreach(var element in elements)
            {
                foreach(var node in element.Nodes)
                {
                    if(node.Contains(clickPoint))
                    {
                        clickedNode = node;
                        break;
                    }
                }
                if(clickedNode != null) break;
            }

            if(clickedNode != null)
            {
                if(selectedNode1 == null)
                {
                    selectedNode1 = clickedNode;
                }
                else
                {
                    selectedNode2 = clickedNode;
                    if(selectedNode1 != selectedNode2)
                    {
                        // 添加节点连接
                        Connections.Add((selectedNode1, selectedNode2));

                        // 更新整个电路状态
                        updateStatus.UpdatePowerStatus(); // 在连接后调用
                    }
                    selectedNode1 = null;
                    selectedNode2 = null;
                }
            }
        }

        // 断开连接
        public void DisconnectElements(PointF clickPoint)
        {
            const float threshold = 10f; // 距离阈值，调整以控制删除范围

            // 找到最近的连接
            float minDistance = float.MaxValue;
            (Node, Node) closestConnection = (null, null);

            foreach(var connection in Connections)
            {
                var node1 = connection.Item1;
                var node2 = connection.Item2;
                float distance = DistancePointToLine(clickPoint, new PointF(node1.X, node1.Y), new PointF(node2.X, node2.Y));

                if(distance < minDistance && distance < threshold)
                {
                    minDistance = distance;
                    closestConnection = connection;
                }
            }

            // 如果找到了合适的连接，则删除
            if(closestConnection.Item1 != null && closestConnection.Item2 != null)
            {
                Connections.Remove(closestConnection);

                // 更新整个电路状态
                updateStatus.UpdatePowerStatus(); // 在断开后调用
                
            }
        }




        // 计算点到线段的最短距离
        private float DistancePointToLine(PointF point, PointF lineStart, PointF lineEnd)
        {
            float dx = lineEnd.X - lineStart.X;
            float dy = lineEnd.Y - lineStart.Y;

            // 线段长度平方
            float lineLengthSquared = dx * dx + dy * dy;

            // 如果线段是一个点
            if(lineLengthSquared == 0) return Distance(point, lineStart);

            // 投影比例
            float t = ((point.X - lineStart.X) * dx + (point.Y - lineStart.Y) * dy) / lineLengthSquared;

            // 限制 t 在 [0, 1] 范围内
            t = Math.Max(0, Math.Min(1, t));

            // 投影点坐标
            PointF projection = new PointF(lineStart.X + t * dx, lineStart.Y + t * dy);

            // 返回点到投影点的距离
            return Distance(point, projection);
        }

        private float Distance(PointF p1, PointF p2)
        {
            return (float)Math.Sqrt((p1.X - p2.X) * (p1.X - p2.X) + (p1.Y - p2.Y) * (p1.Y - p2.Y));
        }
    }
}