﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace 发电厂
{

    
    public class TwoPhaseTransformer : Element
    {
        
        public float Radius { get; set; }
        
        public float Length { get; set; }

        public TwoPhaseTransformer(float x, float y, float radius, float length) : base(x, y)
        {
            Radius = radius;
            Length = length;
            AddNode(X - Length, Y + Radius, 3f);
            AddNode(X + Radius * 3 + Length, Y + Radius, 3f);
        }

        public override void Draw(Graphics g)
        {
            base.Draw(g);  // 绘制电压和电流
            float centerX = X + Radius * 1.5f;
            float centerY = Y + Radius;
            var state = g.Save();
            g.TranslateTransform(centerX, centerY);
            g.RotateTransform(Angle);
            g.TranslateTransform(-(X + Radius * 1.5f), -(Y + Radius));
            Pen pen = IsPowered ? Pens.Red : Pens.Black;
            g.DrawEllipse(pen, X, Y, 2 * Radius, 2 * Radius);
            g.DrawEllipse(pen, X + Radius, Y, 2 * Radius, 2 * Radius);
            g.DrawLine(pen, X, Y + Radius, X - Length, Y + Radius);
            g.DrawLine(pen, X + Radius * 3, Y + Radius, X + Radius * 3 + Length, Y + Radius);
            g.Restore(state);
            foreach (var node in Nodes)
            {
                node.Draw(centerX, centerY, g);
            }
        }

        public override bool Contains(PointF point)
        {
            return point.X >= X && point.X <= X + Radius * 3 && point.Y >= Y && point.Y <= Y + Radius * 2;
        }

        public override void Resize(float scale)
        {
            Radius *= scale;
            Length *= scale;
            TextSize *= scale;
            foreach(var node in Nodes)
            {
                node.Resize(scale);
                float dx = node.X - X;
                float dy = node.Y - Y;
                node.X = X + dx * scale;
                node.Y = Y + dy * scale;
            }
        }

        public override void Rotate(float angle)
        {
            // 增加角度
            Angle += angle;

            // 计算旋转中心
            float centerX = X + Radius * 1.5f;
            float centerY = Y + Radius;

            // 将角度转换为弧度
            double radians = angle * Math.PI / 180;

            // 旋转每个节点
            foreach(var node in Nodes)
            {
                float dx = node.X - centerX;
                float dy = node.Y - centerY;

                // 使用旋转矩阵计算新坐标
                float newX = (float)(dx * Math.Cos(radians) - dy * Math.Sin(radians));
                float newY = (float)(dx * Math.Sin(radians) + dy * Math.Cos(radians));

                node.X = centerX + newX;
                node.Y = centerY + newY;
            }
        }
    }
}
