﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace 发电厂
{
    public class Node
    {
        
        public float X { get; set; }
        
        public float Y { get; set; }
        
        public float Angle { get; set; }
        
        public float NodeRadius { get; set; }
        
        public bool IsPowered { get; set; }
        
        public Node(float x, float y, float noderadius)
        {
            X = x;
            Y = y;
            NodeRadius = noderadius;
            Angle = 0;
            IsPowered = false;
        }

        public void Draw(float centerX, float centerY, Graphics g)
        {
            // 保存当前图形状态
            var state = g.Save();

            // 平移到中心点，然后旋转
            g.TranslateTransform(centerX, centerY);
            g.RotateTransform(Angle);
            g.TranslateTransform(-(centerX), -(centerY));
            // 根据节点开合状态选择颜色
            Brush brush = new SolidBrush(IsPowered ? Color.Red : Color.Black);

            g.FillEllipse(brush, X - NodeRadius, Y - NodeRadius, NodeRadius * 2, NodeRadius * 2);

            // 恢复图形状态
            g.Restore(state);
        }

        public bool Contains(PointF point)
        {
            return (point.X - X) * (point.X - X) + (point.Y - Y) * (point.Y - Y) <= NodeRadius * NodeRadius;
        }

        public void Resize(float scale)
        {
            NodeRadius *= scale;
        }

        public void Move(float dx, float dy)
        {
            X += dx;
            Y += dy;
        }
    }
}
