﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Xml.Serialization;

namespace 发电厂
{

    public abstract class Element
    {
        public float X { get; set; }
        public float Y { get; set; }
        public float Angle { get; set; }
        public float TextSize { get; set; }
        public bool IsPowered { get; set; }
        public List<Node> Nodes { get; set; }
        public float Voltage { get; set; }
        public float Current { get; set; }

        public Element(float x, float y) 
        {
            X = x;
            Y = y;
            Angle = 0;
            TextSize = 8f;
            Nodes = new List<Node>();
            IsPowered = false;
            Voltage = 0f;  // 默认电压为0
            Current = 0f;  // 默认电流为0
        }

        public virtual void Draw(Graphics g)
        {
            // 绘制电压和电流（在元件下方）
            g.DrawString($"电压: {Voltage}V", new Font("Arial", 10), Brushes.Black, X, Y + 20);
            g.DrawString($"电流: {Current}A", new Font("Arial", 10), Brushes.Black, X, Y + 40);
        }
        public abstract bool Contains(PointF point);
        public virtual void Rotate(float angle)
        {
            Angle += angle;
        }
        public virtual void Move(float dx, float dy)
        {
            X += dx;
            Y += dy;
            foreach (var node in Nodes)
            {
                node.X += dx;
                node.Y += dy;
            }
        }
        public abstract void Resize(float scale);

        // 计算电压和电流的方法（根据具体电路元件计算公式，以下是示例）
        public virtual void CalculateVoltageAndCurrent()
        {
            // 示例：假设为电阻，简单计算电流和电压
            if(IsPowered)
            {
                Voltage = 10f;  // 示例电压值
                Current = Voltage / 100f;  // 假设电阻为100欧姆
            }
            else
            {
                Voltage = 0f;
                Current = 0f;
            }
        }

        public virtual void AddNode(float x, float y, float nodeRadius)
        {
            Nodes.Add(new Node(x, y, nodeRadius));
        }

    }
}
