﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace 发电厂
{


    public class Bus : Element
    {

        public float Width { get; set; }

        public float Height { get; set; }

        public Bus(float x, float y, float width, float height) : base(x, y)
        {
            Width = width;
            Height = height;
            AddNode(X, Y, 3f);
            AddNode(X, Y + Height, 3f);
        }

        public override void Draw(Graphics g)
        {
            base.Draw(g);  // 绘制电压和电流
            float centerX = X + Width / 2;
            float centerY = Y + Height / 2;
            var state = g.Save();
            g.TranslateTransform(centerX, centerY);
            g.RotateTransform(Angle);
            g.TranslateTransform(-centerX, -centerY);
            Pen pen = IsPowered ? Pens.Red : Pens.Black;
            g.DrawLine(pen, X, Y, X, Y + Height);
            g.Restore(state);
            foreach (var node in Nodes)
            {
                node.Draw(centerX, centerY, g);
            }
        }

        public override bool Contains(PointF point)
        {
            float dx = 2f;
            return point.X >= X - dx && point.X <= X + Width + dx && point.Y >= Y - dx && point.Y <= Y + Height + dx;
        }

        public override void Resize(float scale)
        {
            Height *= scale;
            Width *= scale;
            foreach (var node in Nodes)
            {
                node.Resize(scale);
                float dx = node.X - X;
                float dy = node.Y - Y;
                node.X = X + dx * scale;
                node.Y = Y + dy * scale;
            }
        }

        public override void Rotate(float angle)
        {
            // 增加角度
            Angle += angle;

            // 计算旋转中心
            float centerX = X + Width / 2;
            float centerY = Y + Height / 2;

            // 将角度转换为弧度
            double radians = angle * Math.PI / 180;

            // 旋转每个节点
            foreach (var node in Nodes)
            {
                float dx = node.X - centerX;
                float dy = node.Y - centerY;

                // 使用旋转矩阵计算新坐标
                float newX = (float)(dx * Math.Cos(radians) - dy * Math.Sin(radians));
                float newY = (float)(dx * Math.Sin(radians) + dy * Math.Cos(radians));

                node.X = centerX + newX;
                node.Y = centerY + newY;
            }
        }
    }

}
