﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml.Linq;

namespace 发电厂.SocketManagement
{
    public partial class ClientForm : Form
    {
        private Socket_Client socketClient;
        private SaveAndLoad saveAndLoad;
        private Form1 form1Instance;  // 引用 Form1 实例
        public ClientForm(Form1 form1)
        {
            InitializeComponent();
            form1Instance = form1;  // 初始化 Form1 实例
            socketClient = new Socket_Client(ClientTextBox);// 将日志文本框传入
            socketClient.StartClient();
            saveAndLoad = new SaveAndLoad(form1Instance.elements, form1Instance.Connections);  // 传递数据到 SaveAndLoad
        }

        private void button_open_Click(object sender, EventArgs e)
        {
            using(OpenFileDialog openFileDialog = new OpenFileDialog())
            {
                openFileDialog.Filter = "Text files (*.txt)|*.txt|All files (*.*)|*.*";
                openFileDialog.Title = "Open Elements Text File";
                if(openFileDialog.ShowDialog() == DialogResult.OK)
                {
                    saveAndLoad.LoadElements(openFileDialog.FileName);
                    socketClient.SendMessage($"打开文件：{openFileDialog.FileName}");
                    form1Instance.Invalidate();
                }
            }
        }

        private void button_save_Click(object sender, EventArgs e)
        {
            using(SaveFileDialog saveFileDialog = new SaveFileDialog())
            {
                saveFileDialog.Filter = "Text files (*.txt)|*.txt|All files (*.*)|*.*";
                saveFileDialog.Title = "Save Elements as Text File";
                if(saveFileDialog.ShowDialog() == DialogResult.OK)
                {
                    saveAndLoad.SaveElements(saveFileDialog.FileName);  // 保存数据到文件
                }
            }
        }
    }
}
