﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace 发电厂
{
    public class UpdateStatus
    {
        private List<Element> elements;
        private List<(Node, Node)> Connections;

        // 构造函数，传入元素和连接列表
        public UpdateStatus(List<Element> elements, List<(Node, Node)> Connections)
        {
            this.elements = elements;
            this.Connections = Connections;
        }

        // 更新电路的通电状态
        public void UpdatePowerStatus()
        {
            // 清除已有的通电状态，重置所有元件和节点
            foreach(var element in elements)
            {
                element.IsPowered = false;
                foreach(var node in element.Nodes)
                {
                    node.IsPowered = false;
                }
            }

            // 从所有发电机节点开始递归更新通电状态
            foreach(var element in elements)
            {
                if(element is Generator generator)
                {
                    foreach(var node in generator.Nodes)
                    {
                        if(!node.IsPowered) // 避免重复更新
                        {
                            UpdatePowerStatusFromNode(node);
                        }
                    }
                }
            }
        }

        private void UpdatePowerStatusFromNode(Node node)
        {
            if(node.IsPowered) return; // 如果节点已通电，跳过

            node.IsPowered = true;

            // 获取节点所属的元件，并更新元件的通电状态
            Element parentElement = elements.FirstOrDefault(e => e.Nodes.Contains(node));
            if(parentElement != null && !parentElement.IsPowered)
            {
                parentElement.IsPowered = true; // 设置元件为通电

                // 将元件内的所有节点设置为通电
                foreach(var n in parentElement.Nodes)
                {
                    if(!n.IsPowered)
                    {
                        UpdatePowerStatusFromNode(n); // 递归更新元件内节点
                    }
                }
            }

            // 遍历所有连接并更新连接节点的状态
            foreach(var connection in Connections)
            {
                Node otherNode = null;
                if(connection.Item1 == node)
                {
                    otherNode = connection.Item2;
                }
                else if(connection.Item2 == node)
                {
                    otherNode = connection.Item1;
                }

                // 判断开关是否开启，只有开启状态才递归更新
                if(otherNode != null && !otherNode.IsPowered)
                {
                    Element connectedElement = elements.FirstOrDefault(e => e.Nodes.Contains(otherNode));
                    if(connectedElement is Switch sw && sw.IsOpen) // 检查开关是否打开
                    {
                        UpdatePowerStatusFromNode(otherNode); // 递归更新连接的节点
                    }
                    else if(!(connectedElement is Switch)) // 不是开关直接更新
                    {
                        UpdatePowerStatusFromNode(otherNode);
                    }
                }
            }
        }
    }
}
