﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

namespace 发电厂
{
    public class Transfer
    {
        private List<Element> elements;
        private PointF lastMousePosition;

        public Transfer(List<Element> elements)
        {
            this.elements = elements;
        }

        // 旋转元素
        public void RotateElement(PointF clickPoint)
        {
            for(int i = elements.Count - 1; i >= 0; i--)
            {
                if(elements[i].Contains(clickPoint))
                {
                    elements[i].Rotate(90f);
                    break;
                }
            }
        }

        // 缩放元素
        public void ResizeElement(PointF clickPoint, float scale)
        {
            foreach(var device in elements)
            {
                if(device.Contains(clickPoint))
                {
                    device.Resize(scale);
                    break;
                }
            }
        }
        public void Form1_MouseDown(PointF currentMousePosition, ref Element selectedElement, ref bool isMovingAll, ActionType currentAction)
        {
            lastMousePosition = currentMousePosition;

            if(currentAction == ActionType.Move)
            {
                foreach(var device in elements)
                {
                    if(device.Contains(lastMousePosition))
                    {
                        selectedElement = device;
                        break;
                    }
                }
            }
            else if(currentAction == ActionType.MoveAll)
            {
                isMovingAll = true; // 启动整体平移
            }
        }

        // 鼠标移动事件，执行平移操作（单个元素或整体元素）
        public void Form1_MouseMove(PointF currentMousePosition, ref Element selectedElement, ref bool isMovingAll)
        {
            // 处理单个元素平移
            if(selectedElement != null && !isMovingAll)
            {
                float dx = currentMousePosition.X - lastMousePosition.X;
                float dy = currentMousePosition.Y - lastMousePosition.Y;
                selectedElement.Move(dx, dy);
                lastMousePosition = currentMousePosition;
            }
            // 处理整体平移
            else if(isMovingAll)
            {
                float dx = currentMousePosition.X - lastMousePosition.X;
                float dy = currentMousePosition.Y - lastMousePosition.Y;
                foreach(var device in elements)
                {
                    device.Move(dx, dy);
                }
                lastMousePosition = currentMousePosition;
            }
        }

        // 鼠标释放事件，结束平移操作
        public void Form1_MouseUp(ref Element selectedElement, ref bool isMovingAll)
        {
            selectedElement = null;
            isMovingAll = false; // 结束整体平移
        }

        // 缩放所有元素
        public void ResizeAllElements(float scaleFactor)
        {
            float centerX = 0;
            float centerY = 0;
            int count_node = 0;

            foreach(var device in elements)
            {
                centerX += device.X;
                centerY += device.Y;
                count_node += device.Nodes.Count;

                foreach(var node in device.Nodes)
                {
                    centerX += node.X;
                    centerY += node.Y;
                }
            }
            centerX /= elements.Count + count_node;
            centerY /= elements.Count + count_node;

            foreach(var device in elements)
            {
                float oldx = device.X;
                float oldy = device.Y;
                float dx = device.X - centerX;
                float dy = device.Y - centerY;
                dx *= scaleFactor;
                dy *= scaleFactor;
                device.X = centerX + dx;
                device.Y = centerY + dy;

                foreach(var node in device.Nodes)
                {
                    node.X += device.X - oldx;
                    node.Y += device.Y - oldy;
                }
                device.Resize(scaleFactor);
            }
        }
    }
}
