﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace 发电厂
{
    public class Information
    {
        private List<Element> elements;

        // 构造函数，传入元素列表
        public Information(List<Element> elements)
        {
            this.elements = elements;
        }

        // 根据点击位置显示元件信息
        public void ShowElementInfo(PointF clickPoint)
        {
            // 查找点击点附近的元件
            Element selectedElement = null;
            foreach(var element in elements)
            {
                if(element.Contains(clickPoint))
                {
                    selectedElement = element;
                    break;
                }
            }

            if(selectedElement != null)
            {
                // 显示选中元件的信息
                string elementInfo = GetElementInfo(selectedElement);
                MessageBox.Show(elementInfo, "元件信息", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        private string GetElementInfo(Element element)
        {
            var info = new StringBuilder();
            info.AppendLine($"类型: {element.GetType().Name}");
            info.AppendLine($"位置: ({element.X}, {element.Y})");
            info.AppendLine($"角度: {element.Angle}");
            info.AppendLine($"文本大小: {element.TextSize}");
            info.AppendLine($"是否通电: {element.IsPowered}");

            // 根据元件类型获取特定信息
            switch(element)
            {
                case Switch sw:
                    info.AppendLine($"宽度: {sw.Width}");
                    info.AppendLine($"高度: {sw.Height}");
                    info.AppendLine($"线段长度: {sw.LineLength}");
                    info.AppendLine($"圆半径: {sw.CircleRadius}");
                    info.AppendLine($"是否开启: {sw.IsOpen}");
                    break;
                case Bus bus:
                    info.AppendLine($"宽度: {bus.Width}");
                    info.AppendLine($"高度: {bus.Height}");
                    break;
                case TwoPhaseTransformer twoPhaseTransformer:
                    info.AppendLine($"半径: {twoPhaseTransformer.Radius}");
                    info.AppendLine($"长度: {twoPhaseTransformer.Length}");
                    break;
                case ThreePhaseTransformer threePhaseTransformer:
                    info.AppendLine($"半径: {threePhaseTransformer.Radius}");
                    info.AppendLine($"长度: {threePhaseTransformer.Length}");
                    break;
                case Generator generator:
                    info.AppendLine($"半径: {generator.Radius}");
                    info.AppendLine($"长度: {generator.Length}");
                    break;
            }
            return info.ToString();
        }
    }
}
