﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Xml.Serialization;

namespace 发电厂
{
    
    public class Switch : Element
    {
        
        public float Width { get; set; }
        
        public float Height { get; set; }
        
        public float LineLength { get; set; }
        
        public float CircleRadius { get; set; }
        public bool IsOpen { get; set; }
        public Switch(float x, float y, float width, float height, float lineLength, float circleRadius) : base(x, y)
        {
            Width = width;
            Height = height;
            LineLength = lineLength;
            CircleRadius = circleRadius;
            AddNode(X - LineLength - CircleRadius, Y + Height / 2, 3f);
            AddNode(X + Width + LineLength + CircleRadius, Y + Height / 2, 3f);
            IsOpen = true;
        }

        public override void Draw(Graphics g)
        {
            base.Draw(g);  // 绘制电压和电流
            // 保存当前图形状态
            var state = g.Save();

            // 平移到中心点，然后旋转
            g.TranslateTransform(X + Width / 2, Y + Height / 2);
            g.RotateTransform(Angle);
            g.TranslateTransform(-(X + Width / 2), -(Y + Height / 2));

            Pen pen = IsPowered ? Pens.Red : (IsOpen ? Pens.Black : Pens.Gray);
            // 绘制开关
            g.DrawRectangle(pen, X, Y, Width, Height);

            // 绘制连接线
            g.DrawLine(pen, X - LineLength, Y + Height / 2, X, Y + Height / 2);
            g.DrawLine(pen, X + Width, Y + Height / 2, X + Width + LineLength, Y + Height / 2);

            // 绘制连接点
            g.DrawEllipse(pen, X - LineLength - CircleRadius * 2, Y + Height / 2 - CircleRadius, 2 * CircleRadius, 2 * CircleRadius);
            g.DrawEllipse(pen, X + Width + LineLength, Y + Height / 2 - CircleRadius, 2 * CircleRadius, 2 * CircleRadius);
            // 恢复图形状态
            g.Restore(state);
            foreach(var node in Nodes)
            {
                node.Draw(X + Width / 2, Y + Height / 2, g);
            }
        }

        public override bool Contains(PointF point)
        {
            bool inRectangle = point.X >= X && point.X <= X + Width && point.Y >= Y && point.Y <= Y + Height;
            float leftCircleCenterX = X - LineLength;
            float leftCircleCenterY = Y + Height / 2;
            float dxLeft = point.X - leftCircleCenterX;
            float dyLeft = point.Y - leftCircleCenterY;
            bool inLeftCircle = (dxLeft * dxLeft + dyLeft * dyLeft) <= CircleRadius * CircleRadius;
            float rightCircleCenterX = X + Width + LineLength;
            float rightCircleCenterY = Y + Height / 2;
            float dxRight = point.X - rightCircleCenterX;
            float dyRight = point.Y - rightCircleCenterY;
            bool inRightCircle = (dxRight * dxRight + dyRight * dyRight) <= CircleRadius * CircleRadius;
            float y1 = Height / 6f;
            bool inLeftLine = (point.X <= X && point.X >= X - LineLength && point.Y >= Y + y1 && point.Y <= Y + Height - y1);
            return inRectangle || inLeftCircle || inRightCircle || inLeftLine;
        }

        public override void Resize(float scale)
        {
            Width *= scale;
            Height *= scale;
            LineLength *= scale;
            CircleRadius *= scale;
            TextSize *= scale;
            foreach(var node in Nodes)
            {
                node.Resize(scale);
                float dx = node.X - X;
                float dy = node.Y - Y;
                node.X = X + dx * scale;
                node.Y = Y + dy * scale;
            }
        }

        public override void Rotate(float angle)
        {
            // 增加角度
            Angle += angle;

            // 计算旋转中心
            float centerX = X + Width / 2;
            float centerY = Y + Height / 2;

            // 将角度转换为弧度
            double radians = angle * Math.PI / 180;
            
            // 旋转每个节点
            foreach(var node in Nodes)
            {
                float dx = node.X - centerX;
                float dy = node.Y - centerY;

                // 使用旋转矩阵计算新坐标
                float newX = (float)(dx * Math.Cos(radians) - dy * Math.Sin(radians));
                float newY = (float)(dx * Math.Sin(radians) + dy * Math.Cos(radians));

                node.X = centerX + newX;
                node.Y = centerY + newY;
            }
        }
    }
}
